'use strict';

function BCPReportsOffersModalCtrl($scope, $rootScope, ReportsList, BanksList, OffersList){
    var elementId = "#modal-reports-offers";

    $scope.modal = false;
    $scope.reportsOffersList = [];
    $scope.offersList = [];

    $scope.$on('Reports:openReportsOffersModal', function(event, params){
        $scope.reportsOffersList = ReportsList.loadData();
        $scope.offersList = OffersList.loadData();
        $scope.openModal();

        setTimeout(function(){
            $("#modal-reports-offers .nano").nanoScroller({alwaysVisible: true});
        }, 300);
    });

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.checkReportOffer = function(Report){
        Report.setChecked(!Report.isChecked());
    }

    $scope.checkOffer = function(Offer){
        Offer.setChecked(!Offer.isChecked());
    }

    $scope.isAnyToBuy = function(){
        return ReportsList.isAnyToBuy() || OffersList.isAnyToBuy();
    }

    $scope.getChildrenOfferList = function(){
        var children = [];
        $scope.offersList.forEach(function(offer){
            if(offer.isChecked() || offer.isBought()){
                children = children.concat(offer.children);
            }
        });
        return children;
    }

    $scope.buyReportsAndOffers = function(){
        var message = {
            title: 'Zakup raportów i usług'
            ,msg: 'Trwa zapisywanie danych. Proszę czekać...'
        }

        function getErrorMessage(data)
        {
            var message = '';
            if(data)
                if(data.data && data.data.message)
                    message = data.data.message;
                else
                    if(data.message)
                        message = data.message;
                    else
                        if(data[0] && data[0].message)
                            message = data[0].message;
                        else
                            message = 'Błąd podczas zakupu raportu.';
            else
                message = 'Błąd podczas zakupu raportu.';

            return message;
        }

        function callbackError(data) {
            var errorMessage = {
                title: 'Zakup raportów i usług'
                ,msg: getErrorMessage(data)
            };
            $rootScope.$broadcast('Message:addMsg', errorMessage);
            $rootScope.$broadcast('Message:delMsg', message);
            setTimeout(function(){
                $rootScope.$broadcast('Message:delMsg', errorMessage);
            }, 4000);
        }

        $scope.reportsOffersList.forEach(function(Report){
            if(Report.isChecked())
            {
                $rootScope.$broadcast('Message:addMsg', message);
                Report.save(function(data) {
                    BanksList.getCurrentAccount().company_bank_service_options[0].value -= Report.price;
                    BanksList.getCurrentAccount().company_bank_service_options[0]._originalValue -= Report.price;
                    $rootScope.$broadcast('Message:delMsg', message);
                }, callbackError);
            }
        });
        $scope.offersList.forEach(function(Offer){
            if(Offer.isChecked()){
                $rootScope.$broadcast('Message:addMsg', message);
                Offer.save(function(data) {
                    BanksList.getCurrentAccount().company_bank_service_options[0].value -= Offer.price;
                    BanksList.getCurrentAccount().company_bank_service_options[0]._originalValue -= Offer.price;
                    $rootScope.$broadcast('Message:delMsg', message);
                }, callbackError);
            }
            Offer.children.forEach(function(children){
                if(children.isChecked()){
                    $rootScope.$broadcast('Message:addMsg', message);
                    children.save(function(data) {
                        BanksList.getCurrentAccount().company_bank_service_options[0].value -= Offer.price;
                        BanksList.getCurrentAccount().company_bank_service_options[0]._originalValue -= Offer.price;
                        $rootScope.$broadcast('Message:delMsg', message);
                    }, callbackError);
                }
            });
        });
    }
}

BCPReportsOffersModalCtrl.$inject = ['$scope', '$rootScope', 'ReportsList', 'BanksList', 'OffersList'];